/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.index;

import com.aptana.core.IFilter;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.index.CSSFileIndexingParticipant;
import com.aptana.editor.common.resolver.URIResolver;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.js.core.index.JSFileIndexingParticipant;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import java.net.URI;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class HTMLFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    private static final String ELEMENT_LINK = "link";
    private static final String ELEMENT_SCRIPT = "script";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_SRC = "src";

    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        if (context == null || index == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        sub.subTask(this.getIndexingMessage(index, context.getURI()));
        IParseRootNode ast = null;
        try {
            ast = context.getAST();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (ast != null) {
            this.walkAST(context, index, (IParseNode)ast, monitor);
        }
        sub.done();
    }

    private void processHTMLElementNode(Index index, URI uri, HTMLElementNode element) {
        URIResolver resolver;
        URI resolved;
        String cssLink;
        String id;
        String cssClass = element.getCSSClass();
        if (!StringUtil.isEmpty((String)cssClass)) {
            StringTokenizer tokenizer = new StringTokenizer(cssClass);
            while (tokenizer.hasMoreTokens()) {
                this.addIndex(index, uri, "css.class", tokenizer.nextToken());
            }
        }
        if (!StringUtil.isEmpty((String)(id = element.getID()))) {
            this.addIndex(index, uri, "css.identifier", id);
        }
        if (element.getName().equalsIgnoreCase(ELEMENT_LINK) && !StringUtil.isEmpty((String)(cssLink = element.getAttributeValue(ATTRIBUTE_HREF))) && (resolved = (resolver = new URIResolver(uri)).resolveURI(cssLink)) != null) {
            this.addIndex(index, uri, "html.resource.css", resolved.toString());
        }
    }

    private void processHTMLSpecialNode(Index index, BuildContext context, HTMLSpecialNode htmlSpecialNode) {
        String language;
        IParseNode child = htmlSpecialNode.getChild(0);
        if (child != null && "com.aptana.contenttype.css".equals(language = child.getLanguage())) {
            CSSFileIndexingParticipant cssIndex = this.createCSSIndexer();
            cssIndex.walkNode(index, context.getURI(), child);
        }
        if (htmlSpecialNode.getName().equalsIgnoreCase(ELEMENT_SCRIPT)) {
            String jsSource = htmlSpecialNode.getAttributeValue(ATTRIBUTE_SRC);
            if (jsSource != null) {
                URIResolver resolver = new URIResolver(context.getURI());
                URI resolved = resolver.resolveURI(jsSource);
                if (resolved != null) {
                    this.addIndex(index, context.getURI(), "html.resource.js", resolved.toString());
                }
            } else if (child != null && "com.aptana.contenttype.js".equals(child.getLanguage())) {
                JSFileIndexingParticipant jsIndex = this.createJSIndexer();
                jsIndex.processParseResults(context, index, child, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected JSFileIndexingParticipant createJSIndexer() {
        return new JSFileIndexingParticipant();
    }

    protected CSSFileIndexingParticipant createCSSIndexer() {
        return new CSSFileIndexingParticipant();
    }

    protected void processNode(Index index, BuildContext context, URI uri, IParseNode current) {
        if (current instanceof HTMLSpecialNode) {
            this.processHTMLSpecialNode(index, context, (HTMLSpecialNode)current);
        } else if (current instanceof HTMLElementNode) {
            this.processHTMLElementNode(index, uri, (HTMLElementNode)current);
        }
    }

    public void walkAST(final BuildContext context, final Index index, IParseNode parent, IProgressMonitor monitor) {
        if (context == null || index == null || parent == null) {
            return;
        }
        final URI uri = context.getURI();
        ParseUtil.treeApply((IParseNode)parent, (IFilter)new IFilter<IParseNode>(){

            public boolean include(IParseNode item) {
                HTMLFileIndexingParticipant.this.processNode(index, context, uri, item);
                return true;
            }
        });
    }
}

